/*
    Shell.h

    Marc Wolfgram,  1/26/91
*/
#pragma lint        3
#pragma memorymodel 0
#pragma optimize   -1

#define DBUG(x) asm { brk x }

#include <types.h>
#include <gsos.h>
#include <quickdraw.h>
#include <misctool.h>
#include <event.h>
#include <control.h>
#include <window.h>
#include <menu.h>
#include <memory.h>
#include <resources.h>
#include "shell.rh"

#define remType     0x7fff
#define remHelp     0x7ffe
#define remScript   0x7ffd

#define _OPEN       1
#define _CLOSE      2
#define _WRITE      3
#define _EVENT      4
#define _ACTIVATE   5
#define _GETLINK    6
#define _VIDMODE    7
#define _PRINT      8
#define _STARTUP   11
#define _SHUTDOWN  12

#define remMenuID   5

#define REM_signature   0x4800  /* 0100 1000 -lo word- */
#define REM_nselector   0x0010  /* -hi word- 0001 00xx */
#define REM_native      0x0020  /*           0010 00xx */
#define REM_script      0x0040  /*           0100 00xx */
#define REM_hexascii    0x0060  /*           0110 00xx */
#define REM_fileroot    0x0080  /*           1000 00xx */
#define REM_tselector   0x0090  /*           1001 00xx */
#define REM_dselector   0x00a0  /*           1010 00xx */
#define REM_general     0x00e0  /*           1110 xxxx */

#define nameSize 87L
#define nameSubSize 58L

struct fMemRec {
    char   *text,
            flag;
    long    nref;
};
typedef struct fMemRec *fMemberPtr, **fMemberHndl;

struct fWindowRec {
    word                Signature,
                        resType;
    long                resID;
    word                resFileID;
    long                remTaskMask;
    word                remSignature;
    Handle              resPrivate;
};
typedef struct fWindowRec fWindowRec, *fWindowRecPtr, **fWindowRecHndl;

struct remFileLink {
    struct remFileLink *next;
    word                resFileID,
                        userID,
                        active;
    long                entry;
    GSString255         fileName;
};
typedef struct remFileLink remFileLink, *remFileLinkPtr;

struct remTypeLink {
    struct remTypeLink *next;
    remFileLinkPtr      link;
    MenuTemplate      **menuHndl;
    word                resType,
                        rFlag,
                        itemID;
    char                resName[32];
};
typedef struct remTypeLink remTypeLink, *remTypeLinkPtr;

struct remStartRes {
    word                version,
                        resType;
    long                minShell;
    word                rFlag;
    long                rMenuID;
    char                resName[32];
};
typedef struct remStartRes **remStartResHndl;

struct resLink {
    word                hostType;
    long                hostID,
                        hostHitTick;
    word                resType;
    long                resID,
                        resHitTick;

};
typedef struct resLink resLink;

struct resLinkRec {
    word                count,
                        resFileID;
    resLink             ref[1];
};
typedef struct resLinkRec resLinkRec, *resLinkRecPtr, **resLinkRecHndl;

struct nameSubRec {
    long                id;
    word                nFlag;
    long                hitTick;
    word                hostType;
    long                hostID;
    char                name[42];
};
typedef struct nameSubRec nameSubRec, *nameSubPtr, **nameSubHndl;

struct nameRec {
    word                type,
                        nFlag;
    nameSubHndl         itemHndl;
    word                count;
    char                name[38],
                        winT[39];
};
typedef struct nameRec nameRec, *namePtr, **nameHndl;

struct workFileRec {
    word                resFileID,
                        sysResID,
                        wFlag;
    GrafPortPtr         rootWinP;
    nameHndl            resNameHndl;
    word                count;
    Handle              pathFile,
                        pathName;       /*              40-12345 */
    char                rootName[41],   /* "* rootname (n) 0"    */
                        editName[44],   /* "*File n: filename0"  */
                        fileName[41],   /* "*Close filename0"    */
                        packName[45];   /* "*Optimize filename0" */
};
typedef struct workFileRec workFileRec;

struct fListCtlRec {
    struct       CtlRec **ctlNext;   /* Handle of next control. */
    WindowPtr    ctlOwner;           /* Pointer to control's window. */
    Rect         ctlRect;            /* Enclosing rectangle. */
    Byte         ctlFlag,            /* Bit flags. */
                 ctlHilite;          /* Highlighted part. */
    Word         ctlValue;           /* Control's value. */
    LongProcPtr  ctlProc,            /* Control's definition procedure. */
                 ctlAction;          /* Control's action procedure. */
    Word         ctlViewSize,
                 ctlListSize;
    Longint      ctlRefCon;          /* Reserved for application's use. */
    Pointer      ctlColor;           /* Pointer to appropriate color table. */
    long         ctlMemDraw;
    word         ctlMemHeight,
                 ctlMemSize;
    fMemberHndl  ctlListRef;
    long         ctlListBar;
    LongWord     ctlID;
    Word         ctlMoreFlags,
                 ctlVersion;
};
typedef struct fListCtlRec fListCtlRec, *fListCtlRecPtr, **fListCtlRecHndl, ***fListCtlRecHndlPtr;

struct prefData {
    word    version,
            pFlag;
    long    fileRef,
            pathRef;
};
typedef struct prefData prefData, *prefDataPtr, **prefDataHndl;

struct master {
	word rType,
		 dType,
		 hType[10];  /* change this if we ever get a weirder dependent */
};
typedef struct master master;

extern word fMemID;

extern GSString255  editPath, userPath,
                    clipFile, prefFile, sResFile, nullFile, workFile, tempFile;
extern char                                     nullFile_s, workFile_s;

/* prototypes */

int             toolerror(void);

/* shell.asm */
word            callREM(word, Pointer);
Pointer         deref(Handle);
word            SetToolError(word);
void            SetVectors(long, word);
word            SetResAttr(word, long);
void            SetResFile1(long);
long            SetResFile2(word, word);

/* ...calls1.c and calls2.c */
word            remAddPrivateData(fPrivateDataRecPtr);
word            remAddResource(fResDataRecPtr);
word            remBadCmdError(long);
word            remBuildLinkHand(fResLinkRecPtr);
word            remColorPalette(fColorRecPtr);
word            remCopyResource(fResDataRecPtr);
word            remCountResources(fResData2RecPtr);
word            remDetachResource(fResRefRecPtr);
word            remDisposeLinkHand(fResLinkRecPtr);
word            remExtendLinkHand(fResDataRecPtr);
word 			remFindHostLink(fResLinkRecPtr);
word            remGetEditorStatus(fResData2RecPtr);
word            remGetIndResource(fResData2RecPtr);
word            remGetKernalID(long);
word            remGetPrivateData(fPrivateDataRecPtr);
word            remGetResourceAttr(fResDataRecPtr);
word            remGetResourceName(fResNameRecPtr);
word            remGetResourceSize(fResData2RecPtr);
word            remGetStdTypeName(fResNameRecPtr);
word            remGetWindowTitle(fResNameRecPtr);
word            remLoadFileData(fLoadFileRecPtr);
word            remLoadResource(fResDataRecPtr);
word            remLoadScrap(fResDataRecPtr);
word            remMarquee(fMarqueeRecPtr);
word            remQueryLinkHand(fResLinkRecPtr);
word            remReleaseResource(fResRefRecPtr);
word            remRelPrivateData(fPrivateDataRecPtr);
word            remRemoveResource(fResRefRecPtr);
word            remRequestEdit(fResDataRecPtr);
word            remResourceConverter(fResConverterRecPtr);
word            remSaveScrap(fResDataRecPtr);
word 			remSelectorMenu(fResDataRecPtr);
word            remSelectorRequest(fResDataRecPtr);
word            remSetPrivateData(fPrivateDataRecPtr);
word            remSetResourceAttr(fResDataRecPtr);
word            remSetResourceID(fResData2RecPtr);
word            remSetResourceName(fResNameRecPtr);
word            remSpecialMagic(fResDataRecPtr);
word 			remSpinCursor(long);
word            remWriteResource(fResRefRecPtr);
word            remUniqueResourceID(fResRefRecPtr);

/* ...event.c */
void            closeREM(word, word);
void 			closeTypes(word);
word            deleteRequested(word, long);
word			dependentsRequested(word, long);
word            editAttributes(word, long);
word            exportRequested(word, long);
GrafPortPtr     findSignature(word, word, word, long);
word            openEditor(word, long, word);
void            swapVidMode(void);
word            winSetup(GrafPortPtr);

/* ...files.c */
resLinkRecHndl  buildItemLink(word, long);
void			CenterWindow(GrafPortPtr);
void			ChangeNoteWindow(GrafPortPtr, char *);
void            checkListStatus(void);
word            countFiles(void);
void            disposeWorkData(word);
prefDataHndl    editPrefs(prefDataHndl);
word            flushWorkFile(word);
void            getPrefs(void);
word		    importRequested(void);
word            MakeReferenceFile(void);
word            NewFile(void);
GrafPortPtr     NoteWindow(char *);
void            openDefault(void);
word            OpenFile(prefDataHndl);
word            openTypeWindow(word, word);
word			OptimizeFile(void);
word            SaveFile(word, word);
void            showTypeInfo(word, word);

/* ...magic.c */
long            copyManager(word, word, word, long, handle);
long 			CopyResource(word, word, word, long);
word 			getListCtlData(word *, word *, long, word);
Handle 			SafeLoadResource2(word *, word, long, word);
void 			SafeReleaseResource(word, word, long, word);
word 			setHost(word, long, word, long, word, long);
word			setLink(resLinkRecHndl, word, long, word, long);
word			addChildRef(resLinkRecHndl, word, long);
resLinkRecHndl 	remFindOwner(word, long);
Handle          remLoadSpecial(word, Longword);
void            remTwiddleSpecial(word, Handle, word);
word            resExists(word, long, word);


/* ...names.c */
word            addItem(word, word, long, char *);
void            changeItem(word, word, long, long, char *);
void            deleteItem(word, word, long);
void            drawNamer(GrafPortPtr);
long            getHitTick(word, word, long);
namePtr         getNameRec(word, word);
nameSubPtr      getNameSubRec(word, word, long);
void            getStdName(word, namePtr, word);
void            killNames(word);
word            loadNames(word);
void            openNamer(void);
void            saveNames(word);
void            setHitTick(word, word, long);
void 			setHostRef(word, word, long, word, long);

/* ...scrap.c */
void 			checkClipboard(void);
void            hiliteRect(CtlRectHndl);
void			itemCopy(void);
void			itemPaste(void);
void            openHelpWin(void);
void 			showClipboard(void);
void            updateHelp1(fWindowRecHndl);
void            updateHelp2(word);

/* ...start.c */
void            buildAddMenu(void);
remTypeLinkPtr  buildTypeLink(remTypeLinkPtr, remStartResHndl, remFileLinkPtr);
void            checkMenuFlag(word);
void            disposeAddMenu(void);
void            disposeFileLink(remFileLinkPtr);
void            disposeTypeLink(remTypeLinkPtr);
remFileLinkPtr  getFileLinkRef(word);
remTypeLinkPtr  getMenuLinkRef(word);
char           *getREMTypeName(word);
remTypeLinkPtr  getTypeLinkRef(word);
void            insertMenu5(MenuTemplate **);
void			MoonCursor(void);
GrafPortPtr     openAboutWin(word);
void            remInit(void);
void            removeMenu5(void);
void            SetupMenu(word);
word 			setupItemMenu(word, word, GrafPortPtr);
word 			setupTypeMenu(word, GrafPortPtr);
void			stringInit(void);
void            startFailText(word);

/* ...general */
word            REM_ACTIVATE(fActivateRecPtr);
word            REM_CLOSE(fCloseRecPtr);
word            REM_EVENT(fEventRecPtr);
word            REM_GETLINK(fLinkRecPtr);
word            REM_OPEN(fOpenRecPtr);
word            REM_PRINT(fCloseRecPtr);
word            REM_SHUTDOWN(fStartStopRecPtr);
word            REM_STARTUP(fStartStopRecPtr);
word            REM_VIDMODE(fOpenRecPtr);
word            REM_WRITE(fCloseRecPtr);
